/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.apps.designer;

import filenet.sim.apps.designer.VWSIMDesignerCore;
import filenet.sim.apps.designer.images.VWSIMImageLoader;
import filenet.sim.apps.designer.resources.VWSIMResource;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JToolBar;

class VWSIMDesignerMainToolbar
extends JToolBar {
    protected AbstractButton m_newButton = null;
    protected AbstractButton m_openButton = null;
    protected AbstractButton m_saveButton = null;
    protected AbstractButton m_fileNETOpenButton = null;
    protected AbstractButton m_fileNETAddNewButton = null;
    protected AbstractButton m_fileNETCheckInButton = null;
    protected AbstractButton m_fileNETCancelCheckOutButton = null;
    protected AbstractButton m_fileNETSaveButton = null;
    protected AbstractButton m_scenarioPropertiesButton = null;
    protected AbstractButton m_validateButton = null;
    protected AbstractButton m_startSimulationButton = null;
    private VWSIMDesignerCore m_designerCore = null;

    public VWSIMDesignerMainToolbar(VWSIMDesignerCore designerCore, boolean canSaveDMS) {
        this.m_designerCore = designerCore;
        this.init(canSaveDMS);
    }

    public void updateToolbarStatus(int nStatus, boolean bCanSaveToDMS) {
        if (bCanSaveToDMS) {
            switch (nStatus) {
                case 100: {
                    this.m_fileNETCancelCheckOutButton.setEnabled(false);
                    this.m_fileNETCheckInButton.setEnabled(false);
                    this.m_fileNETSaveButton.setEnabled(false);
                    this.m_fileNETAddNewButton.setEnabled(true);
                    this.m_fileNETOpenButton.setEnabled(true);
                    break;
                }
                case 101: {
                    this.m_fileNETCancelCheckOutButton.setEnabled(true);
                    this.m_fileNETCheckInButton.setEnabled(true);
                    this.m_fileNETSaveButton.setEnabled(true);
                    this.m_fileNETAddNewButton.setEnabled(true);
                    this.m_fileNETOpenButton.setEnabled(true);
                    break;
                }
                case 102: {
                    this.m_fileNETCancelCheckOutButton.setEnabled(false);
                    this.m_fileNETCheckInButton.setEnabled(false);
                    this.m_fileNETSaveButton.setEnabled(false);
                    this.m_fileNETAddNewButton.setEnabled(true);
                    this.m_fileNETOpenButton.setEnabled(true);
                }
            }
        }
    }

    public void releaseReferences() {
        this.removeAll();
        this.m_newButton.removeActionListener(this.m_designerCore);
        this.m_newButton = null;
        this.m_openButton.removeActionListener(this.m_designerCore);
        this.m_openButton = null;
        this.m_saveButton.removeActionListener(this.m_designerCore);
        this.m_saveButton = null;
        this.m_fileNETOpenButton.removeActionListener(this.m_designerCore);
        this.m_fileNETOpenButton = null;
        this.m_fileNETAddNewButton.removeActionListener(this.m_designerCore);
        this.m_fileNETAddNewButton = null;
        this.m_fileNETCheckInButton.removeActionListener(this.m_designerCore);
        this.m_fileNETCheckInButton = null;
        this.m_fileNETCancelCheckOutButton.removeActionListener(this.m_designerCore);
        this.m_fileNETCancelCheckOutButton = null;
        this.m_fileNETSaveButton.removeActionListener(this.m_designerCore);
        this.m_fileNETSaveButton = null;
        this.m_scenarioPropertiesButton.removeActionListener(this.m_designerCore);
        this.m_scenarioPropertiesButton = null;
        this.m_validateButton.removeActionListener(this.m_designerCore);
        this.m_validateButton = null;
        this.m_startSimulationButton.removeActionListener(this.m_designerCore);
        this.m_startSimulationButton = null;
    }

    private void init(boolean bCanSaveToDMS) {
        this.setFloatable(false);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.m_newButton = this.addToolbarButton("new.gif", VWSIMResource.s_newToolTip, false);
        this.m_openButton = this.addToolbarButton("open.gif", VWSIMResource.s_openToolTip, false);
        this.m_saveButton = this.addToolbarButton("save.gif", VWSIMResource.s_saveToolTip, false);
        VWSIMImageLoader.addToolbarSeparator(this);
        if (bCanSaveToDMS) {
            try {
                this.m_fileNETOpenButton = this.addToolbarButton("checkoutopen.gif", VWSIMResource.s_fileNETOpenCheckOutToolTip, false);
                this.m_fileNETAddNewButton = this.addToolbarButton("add.gif", VWSIMResource.s_fileNETAddNewToolTip, false);
                this.m_fileNETCheckInButton = this.addToolbarButton("checkin.gif", VWSIMResource.s_fileNETCheckInToolTip, false);
                this.m_fileNETCancelCheckOutButton = this.addToolbarButton("cnclchkout.gif", VWSIMResource.s_fileNETCancelCheckOutToolTip, false);
                this.m_fileNETSaveButton = this.addToolbarButton("idmsave.gif", VWSIMResource.s_fileNETSaveToolTip, false);
                VWSIMImageLoader.addToolbarSeparator(this);
                this.updateToolbarStatus(100, bCanSaveToDMS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_scenarioPropertiesButton = this.addToolbarButton("scenario_props.gif", VWSIMResource.s_scenarioPropertiesToolTip, true);
        VWSIMImageLoader.addToolbarSeparator(this);
        this.m_validateButton = this.addToolbarButton("validate.gif", VWSIMResource.s_validateToolTip, false);
        this.m_startSimulationButton = this.addToolbarButton("launch.gif", VWSIMResource.s_startSimulationToolTip, false);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
    }

    private AbstractButton addToolbarButton(String fileName, String toolTip, boolean bUseToggleButton) {
        AbstractButton button = null;
        button = VWSIMImageLoader.createToolBarButton(fileName, toolTip, bUseToggleButton);
        if (button != null) {
            this.add(button);
            button.setRolloverEnabled(true);
            button.addActionListener(this.m_designerCore);
        }
        return button;
    }
}

